'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Button_Abbruch_Click()
    DoCmd.Close
End Sub

Private Sub Button_OK_Click()
On Error GoTo Err_Button_OK_Click

    BerichteUeberschrift = ""
    BerichteFilter = ""
    BerichteJahreswahl = ""

    'Formularvariablen vorbereiten
    If TextEingabe = "Rechnungsbuch_Hauptformular" Then
        BerichteUeberschrift = "Rechnungsbuch " & Me.Jahresauswahl.Value
    Else
        BerichteUeberschrift = "Rechnungssummen nach Kunden fr " & Me.Jahresauswahl.Value
    End If
    BerichteFilter = "[Re_Jahr]=" & Jahresauswahl
    
    'Jahresauswahl schliessen
    ReJahr = Me.Jahresauswahl.Value
    DoCmd.Close acForm, "Rechnungsbuch_Jahreswahl", acSaveNo
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    
    
    'Gre des Reportfensters und Berichts-Zoom optimieren
    'erst Fensterbreite und -hhe ermitteln, und nach dem ffnen des Reports anpassen
    AnwendungGroesseErmitteln
    
    'Formular anzeigen
    DoCmd.OpenReport TextEingabe, acPreview

    'Berichtsfenster nun auf Anwendungsgre zoomen
    DoCmd.MoveSize 0, 0, FormularBreite, FormularHoehe
    'Berichtsvorschau auf ganzes Blatt zoomen
    DoCmd.RunCommand acCmdFitToWindow


Exit_Button_OK_Click:
    Exit Sub

Err_Button_OK_Click:
    MsgBox err.Description
    Resume Exit_Button_OK_Click
    
End Sub

Private Sub Form_Load()
    'Jahresauswahl auf das letzte Rechnungsjahr einstellen
    Me.Jahresauswahl.DefaultValue = Me.Re_Jahr.Value
End Sub
